#!/bin/sh
#################################################################
# SolidNetwork, Inc - EastSolid.com
#
# Source Copyright 2004-2009 SolidNetwork, Inc 
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# (D)DoS Prevention Script - v 1.0
#
#	This file is used by SolidNetwork, Inc staff or closed party
#  with permission. This file includes the full (D)DoS Prevention 
#  Script installer for Linux servers that we will perform on per 
#  client request
#
#                  !! IF ANYTHING FAILS DO NOT MOVE ON !!
#
#################################################################
load_conf()
{
	CONF="/usr/local/ddos/ddos.conf"
	if [ -f "$CONF" ] && [ ! "$CONF" ==	"" ]; then
		source $CONF
	else
		echo "\$CONF not found!"
		exit 1
	fi
}

showhelp()
{
	echo ""
	echo "-------------------------------------------------------"
	echo "SolidNetwork, Inc (D)DoS Prevention Script"
	echo "-------------------------------------------------------"
	echo "General Commands:"
	echo "  --update            : Update Cron Settings (from config)"
	echo "  --help              : Print this help screen"
	echo "-------------------------------------------------------"
	echo
}

unbanip()
{
# +----------+--------------+
# | Variable | Value        |
# +----------+--------------+
# | $FW_BAN  | 0 - iptables |
# | $FW_BAN  | 1 - APF/BFD  |
# | $FW_BAN  | 2 - CSF/LFD  |
# +----------+--------------+

	UNBAN_SCRIPT=`mktemp /tmp/unban.XXXXXXXX`
	TMP_FILE=`mktemp /tmp/unban.XXXXXXXX`
	UNBAN_IP_LIST=`mktemp /tmp/unban.XXXXXXXX`
	echo '#!/bin/sh' > $UNBAN_SCRIPT
	echo "sleep $BAN_PERIOD" >> $UNBAN_SCRIPT
	if [ $FW_BAN -eq 1 ]; then   # This will ban them using APF/BFD
		while read line; do
			echo "$APF -u $line" >> $UNBAN_SCRIPT
			echo $line >> $UNBAN_IP_LIST
		done < $BANNED_IP_LIST
	elif [ $FW_BAN -eq 2 ]; then # This will ban them using CSF/LFD
		while read line; do
			echo "$CSF -dr $line" >> $UNBAN_SCRIPT
			echo $line >> $UNBAN_IP_LIST
		done < $BANNED_IP_LIST
	else                         # This will ban them using iptables
		while read line; do
			echo "$IPT -D INPUT -s $line -j DROP" >> $UNBAN_SCRIPT
			echo $line >> $UNBAN_IP_LIST
		done < $BANNED_IP_LIST
	fi
	echo "grep -v --file=$UNBAN_IP_LIST $IGNORE_IP_LIST > $TMP_FILE" >> $UNBAN_SCRIPT
	echo "mv $TMP_FILE $IGNORE_IP_LIST" >> $UNBAN_SCRIPT
	echo "rm -f $UNBAN_SCRIPT" >> $UNBAN_SCRIPT
	echo "rm -f $UNBAN_IP_LIST" >> $UNBAN_SCRIPT
	echo "rm -f $TMP_FILE" >> $UNBAN_SCRIPT
	. $UNBAN_SCRIPT &
}

add_to_cron()
{
	rm -f $CRON
	sleep 1
	service crond restart
	sleep 1
	echo "SHELL=/bin/sh" > $CRON
	if [ $FREQ -le 2 ]; then
		echo "0-59/$FREQ * * * * root /usr/local/ddos/ddos.sh >/dev/null 2>&1" >> $CRON
	else
		let "START_MINUTE = $RANDOM % ($FREQ - 1)"
		let "START_MINUTE = $START_MINUTE + 1"
		let "END_MINUTE = 60 - $FREQ + $START_MINUTE"
		echo "$START_MINUTE-$END_MINUTE/$FREQ * * * * root /usr/local/ddos/ddos.sh >/dev/null 2>&1" >> $CRON
	fi
	service crond restart
}

sendemail()
{
	echo "Greetings,"
	echo
	echo "This is a message from your server, notifing you that your server *may* be under a (D)DoS attack!"
	echo
	echo "A DDoS attack (Distributed Denial-of-Service Attack) occurs when multiple systems flood the bandwidth or resources of your server. If a DDOS attack is happening to your server, than it is extremely hard to ban or stop. You should contact support ASAP!"
	echo
	echo "A DoS attack (Denial-of-Service Attack) is just like a DDoS attack, but coming from a single source and can be stoped and prevent easily."
	echo
	echo
	echo "The reason you are getting this message, is because I have banned the following IP address from your server."
	echo
	printf "$(cat $BANNED_IP_MAIL)\n"
	echo
	echo
	echo "These IPs will be blocked for $BAN_PERIOD seconds than unbanned."
	echo
	echo "Thank you,"
	echo "(D)DoS Prevention Script"
	echo "SolidNetwork, Inc"
	echo
}

load_conf
while [ $1 ]; do
	case $1 in
		--help)
			showhelp
			exit
			;;
		--update)
			add_to_cron
			exit
			;;
		* )
			showhelp
			exit
			;;
	esac
	shift
done

TMP_PREFIX='/tmp/ddos'
TMP_FILE="mktemp $TMP_PREFIX.XXXXXXXX"
BANNED_IP_MAIL=`$TMP_FILE`
BANNED_IP_LIST=`$TMP_FILE`
echo "Banned the following ip addresses on `date`" > $BANNED_IP_MAIL
echo >>	$BANNED_IP_MAIL
BAD_IP_LIST=`$TMP_FILE`
netstat -ntu | awk '{print $5}' | cut -d: -f1 | sort | uniq -c | sort -nr > $BAD_IP_LIST
cat $BAD_IP_LIST
if [ $KILL -eq 1 ]; then
	IP_BAN_NOW=0
	while read line; do
		CURR_LINE_CONN=$(echo $line | cut -d" " -f1)
		CURR_LINE_IP=$(echo $line | cut -d" " -f2)
		if [ $CURR_LINE_CONN -lt $NO_OF_CONNECTIONS ]; then
			break
		fi
		IGNORE_BAN=`grep -c $CURR_LINE_IP $IGNORE_IP_LIST`
		if [ $IGNORE_BAN -ge 1 ]; then
			continue
		fi
		IP_BAN_NOW=1
		echo "$CURR_LINE_IP with $CURR_LINE_CONN connections" >> $BANNED_IP_MAIL
		echo $CURR_LINE_IP >> $BANNED_IP_LIST
		echo $CURR_LINE_IP >> $IGNORE_IP_LIST
		if [ $FW_BAN -eq 1 ]; then    # This will ban them using APF/LFD
			$FW -d $CURR_LINE_IP
		elif [ $FW_BAN -eq 2 ]; then  # This will ban them using CSF/LFD
			$CSF -d $CURR_LINE_IP
		else                          # This will ban them using iptables
			$IPT -I INPUT -s $CURR_LINE_IP -j DROP
		fi
	done < $BAD_IP_LIST
	if [ $IP_BAN_NOW -eq 1 ]; then
		dt=`date`
		hostname=`hostname`
		serverip=`hostname -i`
		if [ $EMAIL_TO != "" ]; then
			sendemail | mail -s "Possible (D)DoS [Server: $hostname][IP: $serverip]" $EMAIL_TO
		fi
		unbanip
	fi
fi
rm -f $TMP_PREFIX.*
