#!/usr/bin/perl
###############################################################################
# Copyright 2006-2010, Way to the Web Limited
# URL: http://www.configserver.com
# Email: sales@waytotheweb.com
###############################################################################

###############################################################################
# start processline
sub processline {
	my $line = shift;
	my $lgfile = shift;
	$line =~ s/\n//g;
	$line =~ s/\r//g;

	if (-e "/etc/csf/regex.custom.pm") {
		my ($text,$ip,$app,$trigger,$ports,$temp) = &custom_line($line,$lgfile);
		if ($text) {
				return ($text,$ip,$app,$trigger,$ports,$temp);
		}
	}

#openSSH
#RH
	if (($config{LF_SSHD}) and (($lgfile eq "/var/log/messages") or ($lgfile eq "/var/log/secure") or ($lgfile eq $config{SSHD_LOG})) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ sshd\[\d+\]: Failed none for .* from (::ffff:)?(\d+\.\d+\.\d+\.\d+) port \S+ \S+\s*$/)) {
		return ("Failed SSH login from",$2,"sshd");
	}
	if (($config{LF_SSHD}) and (($lgfile eq "/var/log/messages") or ($lgfile eq "/var/log/secure") or ($lgfile eq $config{SSHD_LOG})) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ sshd\[\d+\]: Failed password for .* from (::ffff:)?(\d+\.\d+\.\d+\.\d+) port \S+ \S+\s*$/)) {
		return ("Failed SSH login from",$2,"sshd");
	}
	if (($config{LF_SSHD}) and (($lgfile eq "/var/log/messages") or ($lgfile eq "/var/log/secure") or ($lgfile eq $config{SSHD_LOG})) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ sshd\[\d+\]: Failed keyboard-interactive for .* from (::ffff:)?(\d+\.\d+\.\d+\.\d+) port \S+ \S+\s*$/)) {
		return ("Failed SSH login from",$2,"sshd");
	}
	if (($config{LF_SSHD}) and (($lgfile eq "/var/log/messages") or ($lgfile eq "/var/log/secure") or ($lgfile eq $config{SSHD_LOG})) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ sshd\[\d+\]: Failed password for invalid user .* from (::ffff:)?(\d+\.\d+\.\d+\.\d+) port \S+ \S+\s*$/)) {
		return ("Failed SSH login from",$2,"sshd");
	}
	if (($config{LF_SSHD}) and (($lgfile eq "/var/log/messages") or ($lgfile eq "/var/log/secure") or ($lgfile eq $config{SSHD_LOG})) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ sshd\[\d+\]: Invalid user \S+ from (::ffff:)?(\d+\.\d+\.\d+\.\d+)\s*$/)) {
		return ("Failed SSH login from",$2,"sshd");
	}
	if (($config{LF_SSHD}) and (($lgfile eq "/var/log/messages") or ($lgfile eq "/var/log/secure") or ($lgfile eq $config{SSHD_LOG})) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ sshd\[\d+\]: Did not receive identification string from (::ffff:)?(\d+\.\d+\.\d+\.\d+)\s*$/)) {
		return ("Failed SSH login from",$2,"sshd");
	}

#Debian/Ubuntu
	if (($config{LF_SSHD}) and (($lgfile eq "/var/log/messages") or ($lgfile eq "/var/log/secure") or ($lgfile eq $config{SSHD_LOG})) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ sshd\[\d+\]: Illegal user \S+ from (\d+\.\d+\.\d+\.\d+)\s*$/)) {
		return ("Failed SSH login from",$1,"sshd");
	}

#Gentoo
	if (($config{LF_SSHD}) and (($lgfile eq "/var/log/messages") or ($lgfile eq "/var/log/secure") or ($lgfile eq $config{SSHD_LOG})) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ sshd\[\d+\]: error: PAM: Authentication failure for \S+ from (\d+\.\d+\.\d+\.\d+)\s*$/)) {
		return ("Failed SSH login from",$1,"sshd");
	}

#courier-imap
	if (($config{LF_POP3D}) and ($lgfile eq $config{POP3D_LOG}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ pop3d(-ssl)?: LOGIN FAILED, user=(\S*), ip=\[(::ffff:)?(\d+\.\d+\.\d+\.\d+)\]\s*$/)) {
		return ("Failed POP3 login from",$4,"pop3d");
	}
	if (($config{LF_IMAPD}) and ($lgfile eq $config{IMAPD_LOG}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ imapd(-ssl)?: LOGIN FAILED, user=(\S*), ip=\[(::ffff:)?(\d+\.\d+\.\d+\.\d+)\]\s*$/)) {
		return ("Failed IMAP login from",$4,"imapd");
	}

#uw-imap
	if (($config{LF_POP3D}) and ($lgfile eq $config{POP3D_LOG}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ ipop3d\[\d+\]: Login failed user=\S* auth=\S+ host=\S+ \[(\d+\.\d+\.\d+\.\d+)\]\s*$/)) {
		return ("Failed POP3 login from",$1,"pop3d");
	}
	if (($config{LF_IMAPD}) and ($lgfile eq $config{IMAPD_LOG}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ imapd\[\d+\]: Login failed user=\S* auth=\S+ host=\S+ \[(\d+\.\d+\.\d+\.\d+)\]\s*$/)) {
		return ("Failed IMAP login from",$1,"imapd");
	}

#dovecot
	if (($config{LF_POP3D}) and ($lgfile eq $config{POP3D_LOG}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ dovecot(\[\d+\])?: pop3-login: (Aborted login|Disconnected) \(auth failed, \d+ attempts\): (user=(<\S*>)?, )?method=\S+, rip=(\d+\.\d+\.\d+\.\d+), lip=/)) {
		return ("Failed POP3 login from",$5,"pop3d");
	}
	if (($config{LF_IMAPD}) and ($lgfile eq $config{IMAPD_LOG}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ dovecot(\[\d+\])?: imap-login: (Aborted login|Disconnected) \(auth failed, \d+ attempts\): (user=(<\S*>)?, )?method=\S+, rip=(\d+\.\d+\.\d+\.\d+), lip=/)) {
		return ("Failed IMAP login from",$5,"imapd");
	}

#Kerio Mailserver
	if (($config{LF_POP3D}) and ($lgfile eq $config{POP3D_LOG}) and ($line =~ /^\S+ \S+ POP3: User \S* doesn\'t exist\. Attempt from IP address (\d+\.\d+\.\d+\.\d+)\s*$/)) {
		return ("Failed POP3 login from",$1,"pop3d");
	}
	if (($config{LF_IMAPD}) and ($lgfile eq $config{IMAPD_LOG}) and ($line =~ /^\S+ \S+ IMAP: User \S* doesn\'t exist\. Attempt from IP address (\d+\.\d+\.\d+\.\d+)\s*$/)) {
		return ("Failed IMAP login from",$1,"imapd");
	}
	if (($config{LF_SMTPAUTH}) and ($lgfile eq $config{SMTPAUTH_LOG}) and ($line =~ /^\S+ \S+ smtp: User \S* doesn\'t exist\. Attempt from IP address (\d+\.\d+\.\d+\.\d+)\s*$/)) {
		return ("Failed SMTP AUTH login from",$1,"smtpauth");
	}

#pure-ftpd
	if (($config{LF_FTPD}) and ($lgfile eq $config{FTPD_LOG}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ pure-ftpd: \(\?\@(\d+\.\d+\.\d+\.\d+)\) \[WARNING\] Authentication failed for user/)) {
		return ("Failed FTP login from",$1,"ftpd");
	}

#proftpd
#Jun 21 19:40:47 slate proftpd[4586]: slate.XXX.net (XYZ.XXX.net[1.2.3.4]) - USER dsfsdfsd: no such user found from XYZ.XXX.net [1.2.3.4] to 5.6.7.8:21

	if (($config{LF_FTPD}) and ($lgfile eq $config{FTPD_LOG}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ proftpd\[\d+\]: \S+ \((::ffff:)?\d+\.\d+\.\d+\.\d+\[(::ffff:)?(\d+\.\d+\.\d+\.\d+)\]\) - no such user \'\S*\'/)) {
		return ("Failed FTP login from",$3,"ftpd");
	}
	if (($config{LF_FTPD}) and ($lgfile eq $config{FTPD_LOG}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ proftpd\[\d+\]: \S+ \((::ffff:)?\d+\.\d+\.\d+\.\d+\[(::ffff:)?(\d+\.\d+\.\d+\.\d+)\]\) - USER \S* no such user found from/)) {
		return ("Failed FTP login from",$3,"ftpd");
	}
	if (($config{LF_FTPD}) and ($lgfile eq $config{FTPD_LOG}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ proftpd\[\d+\]: \S+ \([\w\.\-]+\[(::ffff:)?(\d+\.\d+\.\d+\.\d+)\]\) - USER \S* no such user found from/)) {
		return ("Failed FTP login from",$2,"ftpd");
	}
	if (($config{LF_FTPD}) and ($lgfile eq $config{FTPD_LOG}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ proftpd\[\d+\]: \S+ \((::ffff:)?\d+\.\d+\.\d+\.\d+\[(::ffff:)?(\d+\.\d+\.\d+\.\d+)\]\) - SECURITY VIOLATION/)) {
		return ("Failed FTP login from",$3,"ftpd");
	}
	if (($config{LF_FTPD}) and ($lgfile eq $config{FTPD_LOG}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ proftpd\[\d+\]: \S+ \((::ffff:)?\d+\.\d+\.\d+\.\d+\[(::ffff:)?(\d+\.\d+\.\d+\.\d+)\]\) - USER \S* \(Login failed\): Incorrect password\./)) {
		return ("Failed FTP login from",$3,"ftpd");
	}

#vsftpd
	if (($config{LF_FTPD}) and ($lgfile eq $config{FTPD_LOG}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ vsftpd\(pam_unix\)\[\d+\]: authentication failure; logname=\S*\s+\S+\s+\S+\s+\S+\s+ruser=\S*\s+rhost=(\d+\.\d+\.\d+\.\d+)(\s+\S+)?\s*$/)) {
		return ("Failed FTP login from",$1,"ftpd");
	}

#apache v1/v2
	if (($config{LF_HTACCESS}) and ($lgfile eq $config{HTACCESS_LOG}) and ($line =~ /^\[\S+\s+\S+\s+\S+\s+\S+\s+\S+\] \[error\] \[client (\d+\.\d+\.\d+\.\d+)\] user \S* not found:/)) {
		return ("Failed web page login from",$1,"htpasswd");
	}
	if (($config{LF_HTACCESS}) and ($lgfile eq $config{HTACCESS_LOG}) and ($line =~ /^\[\S+\s+\S+\s+\S+\s+\S+\s+\S+\] \[error\] \[client (\d+\.\d+\.\d+\.\d+)\] user \S* authentication failure for/)) {
		return ("Failed web page login from",$1,"htpasswd");
	}

#mod_security v1
	if (($config{LF_MODSEC}) and ($lgfile eq $config{MODSEC_LOG}) and ($line =~ /^\[\S+\s+\S+\s+\S+\s+\S+\s+\S+\] \[error\] \[client (\d+\.\d+\.\d+\.\d+)\] mod_security: Access denied with code/)) {
		return ("mod_security triggered by",$1,"mod_security");
	}

#mod_security v2
	if (($config{LF_MODSEC}) and ($lgfile eq $config{MODSEC_LOG}) and ($line =~ /^\[\S+\s+\S+\s+\S+\s+\S+\s+\S+\] \[error\] \[client (\d+\.\d+\.\d+\.\d+)\] ModSecurity: Access denied with code/)) {
		return ("mod_security triggered by",$1,"mod_security");
	}

#BIND
	if (($config{LF_BIND}) and ($lgfile eq $config{BIND_LOG}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ named\[\d+\]: client (\d+\.\d+\.\d+\.\d+)\#\d+\:( view external\:)? (update|zone transfer) \'.*\' denied$/)) {
		return ("bind triggered by",$1,"bind");
	}

#suhosin
	if (($config{LF_SUHOSIN}) and ($lgfile eq $config{SUHOSIN_LOG})and ($line =~ /^\S+\s+\d+\s+\S+ \S+ suhosin\[\d+\]: ALERT - .* \(attacker \'(\d+\.\d+\.\d+\.\d+)\'/)) {
		if ($line !~ /script tried to increase memory_limit/) {
			return ("Suhosin triggered by",$1,"suhosin");
		}
	}

#cPanel/WHM
	if (($config{LF_CPANEL}) and ($lgfile eq $config{CPANEL_LOG}) and ($line =~ /^(\d+\.\d+\.\d+\.\d+) - (\S+)? \[\S+ \S+\] \"\S+ \S+ \S+\" FAILED LOGIN/)) {
		return ("Failed cPanel login from",$1,"cpanel");
	}

#Exim SMTP AUTH
	if (($config{LF_SMTPAUTH}) and ($lgfile eq $config{SMTPAUTH_LOG}) and ($line =~ /^\S+\s+\S+\s+fixed_login authenticator failed for \S+ (\S+ )?\[(\d+\.\d+\.\d+\.\d+)\]/)) {
		return ("Failed SMTP AUTH login from",$2,"smtpauth");
	}

}
# end processline
###############################################################################
# start processloginline
sub processloginline {
	my $line = shift;

#courier-imap
	if (($config{LT_POP3D}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ pop3d(-ssl)?: LOGIN, user=(\S*), ip=\[(::ffff:)?(\d+\.\d+\.\d+\.\d+)\], port=\S+\s*$/)) {
		return ("pop3d",$2,$4);
	}
	if (($config{LT_IMAPD}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ imapd(-ssl)?: LOGIN, user=(\S*), ip=\[(::ffff:)?(\d+\.\d+\.\d+\.\d+)\], port=\S+\s*$/)) {
		return ("imapd",$2,$4);
	}

#dovecot
	if (($config{LF_POP3D}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ dovecot(\[\d+\])?: pop3-login: Login: user=<(\S*)>, method=\S+, rip=(\d+\.\d+\.\d+\.\d+), lip=/)) {
		return ("pop3d",$2,$3);
	}
	if (($config{LF_IMAPD}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ dovecot(\[\d+\])?: imap-login: Login: user=<(\S*)>, method=\S+, rip=(\d+\.\d+\.\d+\.\d+), lip=/)) {
		return ("imapd",$2,$3);
	}
}
# end processloginline
###############################################################################
# start processsshline
sub processsshline {
	my $line = shift;

#openSSH
#RH
	if (($config{LF_SSH_EMAIL_ALERT}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ sshd\[\d+\]: Accepted (\S+) for (\S+) from (::ffff:)?(\d+\.\d+\.\d+\.\d+) port \S+ \S+\s*$/)) {
		return ($2,$4,$1);
	}
}
# end processsshline
###############################################################################
# start processsuline
sub processsuline {
	my $line = shift;

#Oct 15 16:54:22 homer su: pam_unix(su:session): session opened for user webumake by root(uid=0)
#Oct 15 17:53:12 debian5 su[3042]: pam_unix(su:session): session opened for user csf by root(uid=0)


#RH + Debian/Ubuntu
	if (($config{LF_SU_EMAIL_ALERT}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ su: pam_unix\(su(-l)?:session\): session opened for user\s+(\S+)\s+by\s+(\S+)\s*$/)) {
		return ($2,$3,"Successful login");
	}
	if (($config{LF_SU_EMAIL_ALERT}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ su: pam_unix\(su(-l)?:auth\): authentication failure; logname=\S*\s+\S+\s+\S+\s+\S+\s+ruser=(\S+)+\s+\S+\s+user=(\S+)\s*$/)) {
		return ($3,$2,"Failed login");
	}

	if (($config{LF_SU_EMAIL_ALERT}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ su\[\d+\]: pam_unix\(su(-l)?:session\): session opened for user\s+(\S+)\s+by\s+(\S+)\s*$/)) {
		return ($2,$3,"Successful login");
	}
	if (($config{LF_SU_EMAIL_ALERT}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ su\[\d+\]: pam_unix\(su(-l)?:auth\): authentication failure; logname=\S*\s+\S+\s+\S+\s+\S+\s+ruser=(\S+)+\s+\S+\s+user=(\S+)\s*$/)) {
		return ($3,$2,"Failed login");
	}

	if (($config{LF_SU_EMAIL_ALERT}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ su\(pam_unix\)\[\d+\]: session opened for user\s+(\S+)\s+by\s+(\S+)\s*$/)) {
		return ($1,$2,"Successful login");
	}
	if (($config{LF_SU_EMAIL_ALERT}) and ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ su\(pam_unix\)\[\d+\]: authentication failure; logname=\S*\s+\S+\s+\S+\s+\S+\s+ruser=(\S+)+\s+\S+\s+user=(\S+)\s*$/)) {
		return ($2,$1,"Failed login");
	}

}
# end processsuline
###############################################################################
# start processcpanelline
sub processcpanelline {
	my $line = shift;

	if ($config{LF_CPANEL_ALERT} and ($line =~ /^(\d+\.\d+\.\d+\.\d+)\s+\-\s+root\s+\[[^\]]+\]\s\"[^\"]+\"\s200\s/)) {
		return ($1);
	}
}
# end processcpanelline
###############################################################################
# start scriptlinecheck
sub scriptlinecheck {
	my $line = shift;

	if (($config{LF_SCRIPT_ALERT}) and ($line =~ /^\S+\s+\S+\s+(\[\d+\]\s)?cwd=(\S+) \d+ args:/)) {
		my $fulldir = $2;
		my (undef,$dir,undef) = split(/\//,$fulldir);
		if ($dir eq "home") {return $fulldir}
		if ($cpconfig{HOMEDIR} and ($fulldir =~ /^$cpconfig{HOMEDIR}/)) {return $fulldir}
		if ($cpconfig{HOMEMATCH} and ($dir =~ /$cpconfig{HOMEMATCH}/)) {return $fulldir}
	}
}
# end scriptlinecheck
###############################################################################
# start relaycheck
sub relaycheck {
	my $line = shift;
	my $tline = $line;
	$tline =~ s/".*"/""/g;
	my @bits =split(/\s+/,$tline);
	my $ip;

	if ($tline !~ /^\S+\s+\S+\s+(\[\d+\]\s)?\S+ <=/) {return}

	if ($tline =~ / U=(\S+) P=local /) {
		return ($1, "LOCALRELAY");
	}

	if ($tline =~ / H=[^=]*\[(\d+\.\d+\.\d+\.\d+)\]/) {
		$ip = $1;
	} else {
		return;
	}

	if (($tline =~ / A=(fixed_login|fixed_plain):/) and ($tline =~ / P=(esmtpa|esmtpsa) /)) {
		return ($ip, "AUTHRELAY");
	}

	if ($tline =~ / P=(smtp|esmtp|esmtps) /) {
		return ($ip, "RELAY");
	}

}
# end relaycheck
###############################################################################
# start pslinecheck
sub pslinecheck {
	my $line = shift;
	if ($line !~ /^\S+\s+\d+\s+\S+ [^\s\.]+ kernel:\s(\[[^\]]+\]\s)?Firewall:/) {return}

	if ($line =~ /SRC=(\d+\.\d+\.\d+\.\d+).*DPT=(\d+)/) {
		return ($1,$2);
	}
	if ($line =~ /SRC=(\d+\.\d+\.\d+\.\d+).*PROTO=(ICMP)/) {
		return ($1,$2);
	}
}
# end pslinecheck
###############################################################################
# start statscheck
sub statscheck {
	my $line = shift;
	if ($line =~ /^\S+\s+\d+\s+\S+ [^\s\.]+ kernel:\s(\[[^\]]+\]\s)?Firewall:/) {return 1}
}
# end statscheck
###############################################################################

1;
